package com.example.sefinsa_app.ui.reporte;

import android.app.ProgressDialog;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Build;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.R;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.controllers.PoblacionController;
import com.example.sefinsa_app.controllers.RutaController;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Grupo;
import com.example.sefinsa_app.models.Modalidad;
import com.example.sefinsa_app.models.Poblacion;
import com.example.sefinsa_app.models.Reporte;
import com.example.sefinsa_app.models.Ruta;
import com.example.sefinsa_app.utilities.CurrentFragment;
import com.example.sefinsa_app.utilities.ErrorChecker;
import com.example.sefinsa_app.utilities.ReporteAdapter;
import com.example.sefinsa_app.utilities.VolleyS;
import com.google.android.material.textfield.TextInputLayout;
import com.google.gson.Gson;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;

public class ReporteFragment extends Fragment {

    private ReporteViewModel mViewModel;

    private ArrayList<Reporte> reportes, reportesFiltrados;
    private VolleyS vs;
    private RequestQueue requestQueue;

    private RecyclerView recyclerView;
    private ReporteAdapter reporteAdapter;
    private LinearLayoutManager linearLayoutManager;

    private RutaController rutaController;
    private PoblacionController poblacionController;

    private TextView tvRuta, tvPoblacion, tvColumnaPagado, tvColumnaCobranza;

    private AutoCompleteTextView modalidadesAutoCompleteTextView, rutasAutoCompleteTextView,
            poblacionesAutoCompleteTextView;

    private TextInputLayout tlGrupos;

    private String modalidad_id = "1", ruta_id = "", poblacion_id = "", grupo = "";

    private int previousLength;
    private boolean backSpace;

    private ArrayList<Ruta> rutas;
    private ArrayAdapter<Ruta> rutasAdapter;

    private ArrayList<Grupo> grupos;

    private ArrayList<Poblacion> poblaciones;
    private ArrayAdapter<Poblacion> poblacionesAdapter;

    private ArrayList<Modalidad> modalidades;
    private ArrayAdapter<Modalidad> modalidadesAdapter;

    private int totalPagados = 0;
    private int totalCobranza = 0;
    private SharedPreferences sesion;
    public static ReporteFragment newInstance() {
        return new ReporteFragment();
    }

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container,
                             @Nullable Bundle savedInstanceState) {
        setHasOptionsMenu(true);
        return inflater.inflate(R.layout.fragment_reporte, container, false);
    }

    @Override
    public void onCreateOptionsMenu(@NonNull Menu menu, @NonNull MenuInflater inflater) {
        super.onCreateOptionsMenu(menu, inflater);
    }

    @Override
    public boolean onOptionsItemSelected(@NonNull MenuItem item) {
        switch (item.getItemId()) {
            case R.id.action_refresh:
                requestQueue.getCache().clear();
                getReporteEstimado("1", null, null, null);
                return true;
            default:
                return super.onOptionsItemSelected(item);
        }
    }

    @Override
    public void onViewStateRestored(@Nullable Bundle savedInstanceState) {
        super.onViewStateRestored(savedInstanceState);
        modalidadesAutoCompleteTextView.setText(modalidadesAutoCompleteTextView.getAdapter().getItem(0).toString(), false);
        if(rutasAutoCompleteTextView != null)
            rutasAutoCompleteTextView.setText("");
        if(poblacionesAutoCompleteTextView != null)
            poblacionesAutoCompleteTextView.setText("");
        if(tlGrupos != null)
            tlGrupos.getEditText().setText("");

    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        CurrentFragment.fragment = "ReporteFragment";

        rutasAutoCompleteTextView = view.findViewById(R.id.acRuta);
        poblacionesAutoCompleteTextView= view.findViewById(R.id.acPoblacion);
        modalidadesAutoCompleteTextView = view.findViewById(R.id.acModalidad);
        tvColumnaPagado = view.findViewById(R.id.columnaPagado);
        tvColumnaCobranza = view.findViewById(R.id.columnaCobranza);
        sesion = getActivity().getSharedPreferences("sesion", Context.MODE_PRIVATE);
        tlGrupos = view.findViewById(R.id.tlGrupos);

        initElements(view);

        getReporteEstimado("1", null, null, null);

        linearLayoutManager = new LinearLayoutManager(getContext());
        recyclerView.setLayoutManager(linearLayoutManager);
        reporteAdapter= new ReporteAdapter(getActivity(), reportes);
        recyclerView.setAdapter(reporteAdapter);
        recyclerView.getRecycledViewPool().setMaxRecycledViews(0, 0);

    }

    public void initElements(View view){

        rutaController = new RutaController(getActivity());
        poblacionController = new PoblacionController(getActivity());
        reportes = new ArrayList<Reporte>();

        recyclerView = view.findViewById(R.id.rvEstimados);
        //tvRuta = view.findViewById(R.id.tvRuta);
        //tvPoblacion = view.findViewById(R.id.tvPoblacion);

        /**
         *  MODALIDADES ADAPTER PARA AUTOCOMPLETTEXTVIEW
         */
        modalidades = new ArrayList<Modalidad>();
        getModalidades();

        modalidadesAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener() {

            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Modalidad modalidad = modalidadesAdapter.getItem(i);

                modalidad_id = modalidad.getId();

                ruta_id = "";
                rutasAutoCompleteTextView.setText("");

                poblacion_id = "";
                poblacionesAutoCompleteTextView.setText("");

                grupo = "";
                tlGrupos.getEditText().setText("");

                getReporteEstimado(modalidad_id, null, null, null);
            }

        });

        modalidadesAutoCompleteTextView.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                previousLength = s.length();
            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            @Override
            public void afterTextChanged(Editable s) {
                backSpace = previousLength > s.length();

                if (backSpace && !modalidad_id.equals("")) {

                    modalidad_id = "";
                    modalidadesAutoCompleteTextView.setText("");

                    ruta_id = "";
                    rutasAutoCompleteTextView.setText("");

                    poblacion_id = "";
                    poblacionesAutoCompleteTextView.setText("");

                    grupo = "";
                    tlGrupos.getEditText().setText("");

                    getReporteEstimado("1", null, null, null);

                }

            }
        });


        /**
         *  RUTAS ADAPTER PARA AUTOCOMPLETTEXTVIEW
         */
        rutas = new ArrayList<Ruta>();
        poblaciones = new ArrayList<Poblacion>();
        grupos = new ArrayList<Grupo>();

        getRutas();

        rutasAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener() {

            @RequiresApi(api = Build.VERSION_CODES.N)
            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Ruta ruta = rutasAdapter.getItem(i);
                ruta_id = ruta.getId();

                if(poblacionesAutoCompleteTextView.getText().toString().length() > 0){
                    poblacionesAutoCompleteTextView.setText("");
                }
                if(tlGrupos.getEditText().getText().toString().length() > 0){
                    tlGrupos.getEditText().setText("");
                }

                List<Poblacion> poblacionesFiltro =
                        poblaciones.stream().filter(poblacion -> poblacion.getRuta_id().equals(ruta_id)).collect(Collectors.toList());

                poblacionesAdapter = new ArrayAdapter<Poblacion>(getContext(), android.R.layout.simple_dropdown_item_1line, poblacionesFiltro);
                poblacionesAutoCompleteTextView.setThreshold(1);
                poblacionesAutoCompleteTextView.setAdapter(poblacionesAdapter);


                //getReporteEstimado(modalidad_id, ruta_id, null, null);

                filtrarReporte(modalidad_id, ruta_id);

            }
        });

        rutasAutoCompleteTextView.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                previousLength = s.length();
            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            @Override
            public void afterTextChanged(Editable s) {
                backSpace = previousLength > s.length();

                if (backSpace && !ruta_id.equals("")) {

                    ruta_id = "";
                    rutasAutoCompleteTextView.setText("");

                    poblacion_id = "";
                    poblacionesAutoCompleteTextView.setText("");

                    grupo = "";
                    tlGrupos.getEditText().setText("");

                    //getReporteEstimado(modalidad_id, null, null, null);

                    filtrarReporte(modalidad_id);

                }

            }
        });

        /**
         *  POBLACIONES ADAPTER PARA AUTOCOMPLETTEXTVIEW
         */

        if(poblaciones.size() == 0){
            getPoblaciones(ruta_id);
        }

        poblacionesAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @RequiresApi(api = Build.VERSION_CODES.N)
            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Poblacion poblacion = poblacionesAdapter.getItem(i);
                poblacion_id = poblacion.getId();

                //getReporteEstimado(modalidad_id, ruta_id, poblacion_id, null);
                filtrarReporte(modalidad_id, ruta_id, poblacion_id);
            }
        });

        poblacionesAutoCompleteTextView.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                previousLength = s.length();
            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            @Override
            public void afterTextChanged(Editable s) {
                backSpace = previousLength > s.length();

                if (backSpace && !poblacion_id.equals("")) {

                    poblacion_id = "";
                    poblacionesAutoCompleteTextView.setText("");

                    grupo = "";
                    tlGrupos.getEditText().setText("");

                    //getReporteEstimado(modalidad_id, null, null, null);
                    filtrarReporte(modalidad_id, ruta_id);

                }

            }
        });


        tlGrupos.getEditText().addTextChangedListener(new TextWatcher() {

            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                previousLength = s.length();
            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            @Override
            public void afterTextChanged(Editable s) {
                backSpace = previousLength > s.length();

                if (backSpace) {

                    grupo = "";
                    tlGrupos.getEditText().setText("");

                    poblacion_id = "";
                    poblacionesAutoCompleteTextView.setText("");

                    getReporteEstimado(modalidad_id, null,null,null);

                }
                else{

                    if(s.length() > 0){
                        grupo = s.toString();
                        getReporteEstimado(modalidad_id, ruta_id, poblacion_id, grupo);
                    }

                }

            }
        });

    }

    private void getModalidades()
    {

        Modalidad modalidad15 = new Modalidad();
        modalidad15.setId("1");
        modalidad15.setCantidad("15");
        Modalidad modalidad20 = new Modalidad();
        modalidad20.setId("2");
        modalidad20.setCantidad("20");
        modalidades.add(modalidad15);
        modalidades.add(modalidad20);

        modalidadesAdapter = new ArrayAdapter<Modalidad>(getContext(), android.R.layout.simple_dropdown_item_1line, modalidades);
        modalidadesAutoCompleteTextView.setThreshold(1);
        modalidadesAutoCompleteTextView.setAdapter(modalidadesAdapter);

    }

    public void getRutas()
    {
        String rutaIdSesion = sesion.getString("rutas", "");
        Log.d("getRutas", "Ruta ID de la sesión: " + rutaIdSesion);

        // Descomponer los IDs de la sesión en una lista
        List<String> rutaIdsSesion = Arrays.asList(rutaIdSesion.split(","));
        Log.d("getRutas", "Ruta IDs de la sesión descompuestos: " + rutaIdsSesion);

        if(rutaController.obtener().size() == 0){

            vs = VolleyS.getInstance(this.getContext());
            requestQueue = vs.getRequestQueue();

            JSONObject data = new JSONObject();
            try {
                data.put("func", "rutasActivas");

            } catch (JSONException e) {
                e.printStackTrace();
            }

            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlRutas, data,
                new Response.Listener<JSONObject>() {

                    @Override
                    public void onResponse(JSONObject response) {
                        try {

                            JSONArray data = (JSONArray) response.get("data");

                            for(int i = 0; i < data.length(); i++){

                                JSONObject obj = data.getJSONObject(i);

                                Gson gson = new Gson();
                                Ruta ruta = gson.fromJson(obj.toString(), Ruta.class);

                                if (rutaIdsSesion.contains(ruta.getId())) {
                                    rutas.add(ruta);
                                    rutaController.nueva(ruta);
                                    Log.d("getRutas", "Ruta añadida: " + ruta.toString());
                                }

                            }

                            rutasAdapter = new ArrayAdapter<Ruta>(getContext(), android.R.layout.simple_dropdown_item_1line, rutas);
                            rutasAutoCompleteTextView.setThreshold(1);
                            rutasAutoCompleteTextView.setAdapter(rutasAdapter);

                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                }, new Response.ErrorListener() {

                @Override
                public void onErrorResponse(VolleyError error) {

                    ErrorChecker.checker(error, getActivity());

                }

            });

            request.setRetryPolicy(new DefaultRetryPolicy(
                    0,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            requestQueue.add(request);

        }
        else{
            Log.d("getRutas", "Recuperando rutas guardadas localmente.");
            List<Ruta> rutasGuardadas = rutaController.obtener();
            Log.d("getRutas", "Cantidad de rutas locales encontradas: " + rutasGuardadas.size());

            for (Ruta ruta : rutasGuardadas) {
                Log.d("getRutas", "Ruta local encontrada: " + ruta.toString());
                // Verificar si el ID de la ruta está en la lista de IDs de la sesión
                if (rutaIdsSesion.contains(ruta.getId())) {
                    rutas.add(ruta);
                    Log.d("getRutas", "Ruta añadida tras filtrar: " + ruta);
                }
            }

            rutasAdapter = new ArrayAdapter<Ruta>(getContext(), android.R.layout.simple_dropdown_item_1line, rutas);
            rutasAutoCompleteTextView.setThreshold(1);
            rutasAutoCompleteTextView.setAdapter(rutasAdapter);
        }

    }

    private void getPoblaciones(String ruta_id)
    {
        if(poblacionController.obtener().size() == 0) {

            vs = VolleyS.getInstance(this.getContext());
            requestQueue = vs.getRequestQueue();

            JSONObject data = new JSONObject();
            try {
                data.put("func", "index");

            } catch (JSONException e) {
                e.printStackTrace();
            }

            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPoblaciones, data,
                    new Response.Listener<JSONObject>() {

                        @Override
                        public void onResponse(JSONObject response) {
                            try {

                                JSONArray data = (JSONArray) response.get("data");

                                for (int i = 0; i < data.length(); i++) {

                                    JSONObject obj = data.getJSONObject(i);

                                    Gson gson = new Gson();
                                    Poblacion poblacion = gson.fromJson(obj.toString(), Poblacion.class);

                                    poblaciones.add(poblacion);
                                    poblacionController.nueva(poblacion);

                                }

                                poblacionesAdapter = new ArrayAdapter<Poblacion>(getContext(), android.R.layout.simple_dropdown_item_1line, poblaciones);
                                poblacionesAutoCompleteTextView.setThreshold(1);
                                poblacionesAutoCompleteTextView.setAdapter(poblacionesAdapter);

                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }
                    }, new Response.ErrorListener() {

                @Override
                public void onErrorResponse(VolleyError error) {

                    ErrorChecker.checker(error, getActivity());

                }
            });

            request.setRetryPolicy(new DefaultRetryPolicy(
                    0,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            requestQueue.add(request);
        }
        else{

            poblaciones = poblacionController.obtener();

            poblacionesAdapter = new ArrayAdapter<Poblacion>(getContext(), android.R.layout.simple_dropdown_item_1line, poblaciones);
            poblacionesAutoCompleteTextView.setThreshold(1);
            poblacionesAutoCompleteTextView.setAdapter(poblacionesAdapter);

        }
    }


    private void getReporteEstimado(String modalidad_id, String ruta_id, String poblacion_id, String grupo) {
        ProgressDialog dialog = new ProgressDialog(getActivity(), R.style.AppMaterialAlertDialogStyle);
        dialog.setMessage("Cargando datos, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();

        ExecutorService executor = Executors.newSingleThreadExecutor(); // Para ejecutar en segundo plano
        executor.execute(() -> {
            DatabaseHelper dbHelper = new DatabaseHelper(requireActivity());
            SQLiteDatabase db = dbHelper.getReadableDatabase();

            int totalPagados = 0;
            int totalCobranza = 0;

            reportes.clear();

            // Construcción del WHERE dinámico
            StringBuilder whereClause = new StringBuilder();
            whereClause.append("WHERE (CASE WHEN prestamos.status = 2 AND DATE(prestamos.updated_at) = DATE('now') THEN prestamos.status IN (0,2) ELSE prestamos.status = 0 END) ");

            if (ruta_id != null && !ruta_id.equals("0")) {
                whereClause.append("AND clientes.ruta_id = ").append(ruta_id).append(" ");
                Log.d("getReporteEstimado", "Ruta ID aplicada: " + ruta_id);
            }
            if (poblacion_id != null && !poblacion_id.equals("0")) {
                whereClause.append("AND clientes.poblacion_id = ").append(poblacion_id).append(" ");
                Log.d("getReporteEstimado", "Población ID aplicada: " + poblacion_id);
            }
            if (grupo != null && !grupo.equals("0")) {
                whereClause.append("AND prestamos.grupo_poblacion = ").append(grupo).append(" ");
                Log.d("getReporteEstimado", "Grupo aplicado: " + grupo);
            }
            if (modalidad_id != null) {
                whereClause.append("AND (poblaciones.id IN (31, 1, 2, 4) OR prestamos.modalidad_semanas = ").append(modalidad_id).append(") ");
                Log.d("getReporteEstimado", "Modalidad aplicada: " + modalidad_id);
            }

            String query = "SELECT TABLA_ESTIMADOS.nombre_poblacion, TABLA_ESTIMADOS.poblacion_id, " +
                    "TABLA_ESTIMADOS.nombre_ruta, TABLA_ESTIMADOS.ruta_id, TABLA_ESTIMADOS.modalidad_semanas, " +
                    "MAX(CASE WHEN TABLA_ESTIMADOS.fecha_pago IS NULL THEN '' ELSE TABLA_ESTIMADOS.fecha_pago END) AS fecha_pago, " +
                    "SUM(TABLA_ESTIMADOS.cantidad_esperada_pago) AS estimado, " +
                    "COUNT(CASE WHEN TABLA_ESTIMADOS.fecha_pago IS NOT NULL THEN TABLA_ESTIMADOS.cantidad_esperada_pago END) AS cantidad_prestamos, " +
                    "TABLA_PAGADOS.pagado, " +
                    "IFNULL(TABLA_PAGADOS.cantidad_pagados, 0) AS cantidad_pagados, " +
                    "TABLA_COBRANZA.faltante, IFNULL(TABLA_COBRANZA.cantidad_no_pagados, 0) AS cantidad_no_pagados " +
                    "FROM ( " +
                    "    SELECT pagos.cantidad_esperada_pago, pagos.semana, poblaciones.primer_dia_cobro, " +
                    "    MAX(CASE WHEN pagos.fecha_pago >= DATE('now') AND pagos.fecha_pago < DATE('now', '+7 days') THEN pagos.fecha_pago END) AS fecha_pago, " +
                    "    clientes.nombre_completo, clientes.poblacion_id, clientes.ruta_id, prestamos.grupo_poblacion, prestamos.modalidad_semanas, " +
                    "    poblaciones.nombre_poblacion, rutas.nombre_ruta, prestamos.status, prestamos.updated_at " +
                    "    FROM pagos " +
                    "    INNER JOIN prestamos ON prestamos.id = pagos.prestamo_id " +
                    "    INNER JOIN clientes ON clientes.id = prestamos.cliente_id " +
                    "    INNER JOIN poblaciones ON poblaciones.id = clientes.poblacion_id " +
                    "    INNER JOIN rutas ON rutas.id = clientes.ruta_id " +
                    whereClause.toString() +
                    "    GROUP BY prestamos.id, clientes.poblacion_id ORDER BY clientes.poblacion_id DESC " +
                    ") AS TABLA_ESTIMADOS " +
                    "LEFT JOIN ( " +
                    "    SELECT SUM(pagos.cantidad_normal_pagada) AS pagado, clientes.poblacion_id, " +
                    "    COUNT(pagos.cantidad_normal_pagada) AS cantidad_pagados " +
                    "    FROM pagos " +
                    "    INNER JOIN prestamos ON prestamos.id = pagos.prestamo_id " +
                    "    INNER JOIN clientes ON clientes.id = prestamos.cliente_id " +
                    "    INNER JOIN poblaciones ON poblaciones.id = clientes.poblacion_id " +
                    "    INNER JOIN rutas ON rutas.id = clientes.ruta_id " +
                    whereClause.toString() +
                    "    AND pagos.status IN (1, 3) AND pagos.fecha_pago_realizada = DATE('now') " +
                    "    GROUP BY clientes.poblacion_id ORDER BY clientes.poblacion_id DESC " +
                    ") AS TABLA_PAGADOS " +
                    "ON TABLA_ESTIMADOS.poblacion_id = TABLA_PAGADOS.poblacion_id " +
                    "LEFT JOIN ( " +
                    "    SELECT SUM(pagos.cantidad_pendiente) AS faltante, clientes.poblacion_id, " +
                    "    COUNT(pagos.cantidad_pendiente) AS cantidad_no_pagados " +
                    "    FROM pagos " +
                    "    INNER JOIN prestamos ON prestamos.id = pagos.prestamo_id " +
                    "    INNER JOIN clientes ON clientes.id = prestamos.cliente_id " +
                    "    INNER JOIN poblaciones ON poblaciones.id = clientes.poblacion_id " +
                    "    INNER JOIN rutas ON rutas.id = clientes.ruta_id " +
                    whereClause.toString() +
                    "    AND prestamos.status IN (0, -1) AND pagos.status = -1 " +
                    "    AND pagos.fecha_pago >= DATE('now') AND pagos.fecha_pago < DATE('now', '+7 days') " +
                    "    GROUP BY clientes.poblacion_id ORDER BY clientes.poblacion_id DESC " +
                    ") AS TABLA_COBRANZA " +
                    "ON TABLA_ESTIMADOS.poblacion_id = TABLA_COBRANZA.poblacion_id " +
                    "GROUP BY TABLA_ESTIMADOS.nombre_poblacion, TABLA_ESTIMADOS.poblacion_id " +
                    "ORDER BY TABLA_ESTIMADOS.poblacion_id DESC";

            Cursor cursor = db.rawQuery(query, null);

            if (cursor != null && cursor.moveToFirst()) {
                Log.d("getReporteEstimado", "Datos encontrados, procesando resultados...");
                do {
                    Reporte reporte = new Reporte();
                    reporte.setNombre_poblacion(cursor.getString(cursor.getColumnIndexOrThrow("nombre_poblacion")));
                    reporte.setCantidad_pagados(cursor.getString(cursor.getColumnIndexOrThrow("cantidad_pagados")));
                    reporte.setCantidad_no_pagados(cursor.getString(cursor.getColumnIndexOrThrow("cantidad_no_pagados")));
                    reporte.setEstimado(cursor.getString(cursor.getColumnIndexOrThrow("estimado")));
                    reporte.setPoblacion_id(cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id")));
                    reporte.setNombre_ruta(cursor.getString(cursor.getColumnIndexOrThrow("nombre_ruta")));
                    reporte.setRuta_id(cursor.getString(cursor.getColumnIndexOrThrow("ruta_id")));
                    reporte.setModalidad_semanas(cursor.getString(cursor.getColumnIndexOrThrow("modalidad_semanas")));
                    reporte.setFecha_pago(cursor.getString(cursor.getColumnIndexOrThrow("fecha_pago")));
                    reporte.setPagado(cursor.getString(cursor.getColumnIndexOrThrow("pagado")));
                    reporte.setCantidad_prestamos(cursor.getString(cursor.getColumnIndexOrThrow("cantidad_prestamos")));
                    reportes.add(reporte);
                    Log.d("getReporteEstimado", "Actualizando el adaptador, reportes: " + reportes.toString());
                    Log.d("getReporteEstimado", "Reporte añadido: " + reporte.toString());
                } while (cursor.moveToNext());

                cursor.close();
            } else {
                Log.d("getReporteEstimado", "No se encontraron datos");
            }

            db.close();
            executor.shutdown();

            // Actualización en la UI
            getActivity().runOnUiThread(() -> {
                dialog.cancel();
                tvColumnaPagado.setText("PAGADO \n (" + totalPagados + ")");
                tvColumnaCobranza.setText("COBRANZA \n (" + totalCobranza + ")");

                reporteAdapter.addAll(reportes);
                reporteAdapter.notifyItemRangeChanged(0, reportes.size());
                Log.d("getReporteEstimado", "Actualizando el adaptador, reportes: " + reportes.size());

            });
        });
    }



    /*
    private void getReporteEstimado(String modalidad_id, String ruta_id, String poblacion_id, String grupo)
    {
        ProgressDialog dialog = new ProgressDialog(getActivity(),  R.style.AppMaterialAlertDialogStyle);
        dialog.setMessage("Cargando datos, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();

        vs = VolleyS.getInstance(getActivity());
        requestQueue = vs.getRequestQueue();

        JSONObject data = new JSONObject();
        try {
            data.put("func", "reporteEstimadoApp");
            data.put("modalidad", modalidad_id);
            data.put("ruta", ruta_id);
            data.put("poblacion", poblacion_id);
            data.put("grupo", grupo);
        } catch (JSONException e) {
            e.printStackTrace();
        }

        Log.d("SEND", data.toString());

        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                new Response.Listener<JSONObject>() {

                    @Override
                    public void onResponse(JSONObject response) {
                        try {
                            dialog.cancel();
                            //String data = response.get("data").toString();
                            JSONArray data = (JSONArray) response.get("data");

                            Log.d("DATA", data.toString());

                            totalPagados = 0;
                            totalCobranza = 0;
                            reporteAdapter.clear();
                            reportes.clear();

                            for(int i = 0; i < data.length(); i++){
                                JSONObject obj = data.getJSONObject(i);
                                Gson gson = new Gson();
                                Reporte reporte = gson.fromJson(obj.toString(), Reporte.class);
                                totalPagados += Integer.parseInt(reporte.getCantidad_pagados());
                                totalCobranza += Integer.parseInt(reporte.getCantidad_no_pagados());
                                reportes.add(reporte);
                                Log.d("getReporteEstimado", "Actualizando el adaptador, reportes: " + reportes.toString());
                            }
                            Log.d("getReporteEstimado", "Actualizando el adaptador, reportes: " + reportes.size());
                            tvColumnaPagado.setText("PAGADO \n ("+totalPagados+")");
                            tvColumnaCobranza.setText("COBRANZA \n ("+totalCobranza+")");

                            reporteAdapter.addAll(reportes);
                            reporteAdapter.notifyItemRangeChanged(reportes.size(), 1);

                            recyclerView.setVisibility(View.VISIBLE);
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                }, new Response.ErrorListener() {

            @Override
            public void onErrorResponse(VolleyError error) {
                dialog.cancel();
                ErrorChecker.checker(error, getActivity());
            }
        }) ;

        request.setRetryPolicy(new DefaultRetryPolicy(
                5000,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        request.setShouldCache(false);
        requestQueue.add(request);

    }
    */

    private void filtrarReporte(String modalidad_id, String ruta_id, String poblacion_id) {

        reportesFiltrados = new ArrayList<>();
        reportesFiltrados.clear();

        totalPagados = 0;
        totalCobranza = 0;

        for (Reporte reporte : reportes) {
            // Comparaciones seguras para evitar NullPointerException
            boolean modalidadCoincide = modalidad_id != null && modalidad_id.equals(reporte.getModalidad_semanas());
            boolean rutaCoincide = ruta_id != null && ruta_id.equals(reporte.getRuta_id());
            boolean poblacionCoincide = poblacion_id != null && poblacion_id.equals(reporte.getPoblacion_id());

            if (modalidadCoincide && rutaCoincide && poblacionCoincide) {
                totalPagados += safeParseInt(reporte.getCantidad_pagados());
                totalCobranza += safeParseInt(reporte.getCantidad_no_pagados());
                reportesFiltrados.add(reporte);
            } else if (!modalidadCoincide && rutaCoincide && poblacionCoincide) {
                totalPagados += safeParseInt(reporte.getCantidad_pagados());
                totalCobranza += safeParseInt(reporte.getCantidad_no_pagados());
                reportesFiltrados.add(reporte);
            }
        }

        tvColumnaPagado.setText("PAGADO \n (" + totalPagados + ")");
        tvColumnaCobranza.setText("COBRANZA \n (" + totalCobranza + ")");

        if (!reportesFiltrados.isEmpty()) {
            reporteAdapter.setListaFiltrada(reportesFiltrados);
        }
    }

    private void filtrarReporte(String modalidad_id, String ruta_id) {

        reportesFiltrados = new ArrayList<>();
        reportesFiltrados.clear();

        totalPagados = 0;
        totalCobranza = 0;
        Log.d("filtrarReporte", "modalidad_id: " + modalidad_id + ", ruta_id: " + ruta_id);

        for (Reporte reporte : reportes) {
            // Comparación segura con objetos posiblemente nulos
            boolean modalidadCoincide = modalidad_id != null && modalidad_id.equals(reporte.getModalidad_semanas());
            boolean rutaCoincide = ruta_id != null && ruta_id.equals(reporte.getRuta_id());

            if (modalidadCoincide && rutaCoincide) {
                totalPagados += safeParseInt(reporte.getCantidad_pagados());
                totalCobranza += safeParseInt(reporte.getCantidad_no_pagados());
                reportesFiltrados.add(reporte);
            } else if (!modalidadCoincide && rutaCoincide) {
                totalPagados += safeParseInt(reporte.getCantidad_pagados());
                totalCobranza += safeParseInt(reporte.getCantidad_no_pagados());
                reportesFiltrados.add(reporte);
            }
        }

        tvColumnaPagado.setText("PAGADO \n (" + totalPagados + ")");
        tvColumnaCobranza.setText("COBRANZA \n (" + totalCobranza + ")");

        if (!reportesFiltrados.isEmpty()) {
            reporteAdapter.setListaFiltrada(reportesFiltrados);
        }
    }

    // Método para convertir enteros de forma segura
    private int safeParseInt(String value) {
        try {
            return value != null ? Integer.parseInt(value) : 0;
        } catch (NumberFormatException e) {
            return 0;
        }
    }


    private void filtrarReporte(String modalidad_id){

        reportesFiltrados = new ArrayList<>();
        reportesFiltrados.clear();

        totalPagados = 0;
        totalCobranza = 0;

        for(Reporte reporte: reportes){

            if(reporte.getModalidad_semanas().equals(modalidad_id))
            {
                totalPagados += Integer.parseInt(reporte.getCantidad_pagados());
                totalCobranza += Integer.parseInt(reporte.getCantidad_no_pagados());
                reportesFiltrados.add(reporte);
            }
        }

        tvColumnaPagado.setText("PAGADO \n ("+totalPagados+")");
        tvColumnaCobranza.setText("COBRANZA \n ("+totalCobranza+")");

        if(!reportesFiltrados.isEmpty()){
            reporteAdapter.setListaFiltrada(reportesFiltrados);
        }
        else{
        }
    }

}